# ITXBASE

A Yii 2 Basic Project Template foundation preconfigured with database-backed RBAC roles (Guest, User, Super Admin) so it can grow into the CRM, accounting, and rent-management products you described.

## Requirements
- PHP 8.0+ with the intl, mbstring, and pdo_mysql extensions
- Composer
- MySQL 5.7+/MariaDB 10.3+

## Installation
1. Install Composer dependencies:
   ```bash
   composer install
   ```
2. Configure your database connection in `app/config/db.php` (and optionally `app/config/test_db.php`). Replace the DSN, username, and password with your own credentials, e.g.:
   ```php
   return [
       'class' => 'yii\\db\\Connection',
       'dsn' => 'mysql:host=localhost;dbname=itxbase',
       'username' => 'itxroot',
       'password' => 'ITXbase#123',
       'charset' => 'utf8',
   ];
   ```
3. Apply database migrations to provision the RBAC tables and seed the initial roles:
   ```bash
   php yii migrate --migrationPath=@app/migrations
   ```
   This creates the standard `auth_*` tables and inserts the hierarchical roles:
   - **Guest** – read-only access for unauthenticated visitors
   - **User** – standard authenticated permissions
   - **Super Admin** – full administrative control

4. Log in with one of the preseeded demo accounts that mirror the RBAC hierarchy:
   - Username `admin` / Password `admin` (Super Admin role)
   - Username `user` / Password `user` (User role)
   - Username `guest` / Password `guest` (Guest role)

5. (Optional) Assign roles to users via the console once you have user records:
   ```bash
   php yii rbac/assign <role> <user-id>
   ```
   You can also manage assignments programmatically through `Yii::$app->authManager`.

## Running the application
- Start a local development server:
  ```bash
  php yii serve --docroot=@app/web --port=8080
  ```
- Or configure your preferred web server to point at `app/web` as the document root.

## Next steps
- Create feature modules under `app/modules/` for CRM, accounting, and rent management while reusing the shared RBAC setup.
- Add domain-specific migrations (e.g., contacts, invoices, leases) alongside `app/migrations/`.
