<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Html;
use yii\helpers\Url;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);

$this->registerCssFile('https://cdn.jsdelivr.net/npm/@mdi/font@7.4.47/css/materialdesignicons.min.css');
$this->registerCssFile('https://cdn.jsdelivr.net/npm/vuetify@3.5.7/dist/vuetify.min.css');

$this->registerJsFile('https://cdn.jsdelivr.net/npm/vue@3.5.11/dist/vue.global.prod.js', ['position' => \yii\web\View::POS_END]);
$this->registerJsFile('https://cdn.jsdelivr.net/npm/vuetify@3.5.7/dist/vuetify.min.js', ['position' => \yii\web\View::POS_END]);

$navItems = [
    ['label' => 'Home', 'url' => Url::to(['/site/index']), 'type' => 'link'],
    ['label' => 'About', 'url' => Url::to(['/site/about']), 'type' => 'link'],
    ['label' => 'Contact', 'url' => Url::to(['/site/contact']), 'type' => 'link'],
];
$hasLogout = false;

if (Yii::$app->user->isGuest) {
    $navItems[] = ['label' => 'Login', 'url' => Url::to(['/site/login']), 'type' => 'link'];
} else {
    $navItems[] = [
        'label' => 'Logout (' . Yii::$app->user->identity->username . ')',
        'url' => Url::to(['/site/logout']),
        'type' => 'logout',
    ];
    $hasLogout = true;
}
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div id="app">
    <v-app>
        <v-navigation-drawer v-model="drawer" app temporary>
            <v-list density="comfortable">
                <v-list-item v-for="item in items" :key="item.label" @click="handleNavigation($event, item)">
                    <v-list-item-title>{{ item.label }}</v-list-item-title>
                </v-list-item>
            </v-list>
        </v-navigation-drawer>

        <v-app-bar app color="primary" density="comfortable" dark>
            <v-app-bar-nav-icon class="d-md-none" @click="drawer = !drawer"></v-app-bar-nav-icon>
            <v-app-bar-title><?= Html::encode(Yii::$app->name) ?></v-app-bar-title>
            <v-spacer></v-spacer>
            <v-toolbar-items class="d-none d-md-flex">
                <v-btn
                    v-for="item in items"
                    :key="item.label"
                    class="text-none"
                    variant="text"
                    @click="handleNavigation($event, item)"
                    :href="item.type === 'link' ? item.url : undefined"
                >
                    {{ item.label }}
                </v-btn>
            </v-toolbar-items>
        </v-app-bar>

        <v-main>
            <v-container class="py-4">
                <?= Alert::widget() ?>
                <?= $content ?>
            </v-container>
        </v-main>

        <v-footer app color="grey-lighten-4">
            <v-container class="text-muted">
                <div class="d-flex flex-column flex-sm-row justify-space-between w-100 text-center text-sm-start">
                    <div>&copy; My Company <?= date('Y') ?></div>
                    <div>Powered by iTexxia &amp; <?= date('Y') ?></div>
                </div>
            </v-container>
        </v-footer>
    </v-app>
</div>

<?php if ($hasLogout): ?>
    <form id="logout-form" action="<?= Url::to(['/site/logout']) ?>" method="post" style="display: none;">
        <?= Html::hiddenInput(Yii::$app->request->csrfParam, Yii::$app->request->getCsrfToken()) ?>
    </form>
<?php endif; ?>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        if (typeof window.Vue === 'undefined' || typeof window.Vuetify === 'undefined') {
            console.error('Vue or Vuetify could not be loaded, skipping layout initialisation.');
            return;
        }

        const { createApp } = window.Vue;
        const { createVuetify } = window.Vuetify;

        const vuetify = createVuetify({
            components: window.Vuetify.components,
            directives: window.Vuetify.directives,
        });

        createApp({
            data() {
                return {
                    drawer: false,
                    items: <?= json_encode($navItems, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>,
                };
            },
            methods: {
                handleNavigation(event, item) {
                    if (item.type === 'logout') {
                        event.preventDefault();
                        const logoutForm = document.getElementById('logout-form');
                        if (logoutForm) {
                            logoutForm.submit();
                        }
                    } else if (item.url) {
                        window.location.href = item.url;
                    }
                    this.drawer = false;
                },
            },
        })
            .use(vuetify)
            .mount('#app');
    });
</script>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
