<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\ContactForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\captcha\Captcha;

$this->title = 'Contact';
$this->params['breadcrumbs'][] = $this->title;


$this->registerCss(<<<'CSS'
.site-contact {
    --page-background: #f8fafc;
    --card-background: #ffffff;
    --card-border: rgba(15, 23, 42, 0.08);
    --header-background: #ffffff;
    --header-text: #0f172a;
    --logo-background: rgba(37, 99, 235, 0.08);
    --logo-border: rgba(37, 99, 235, 0.18);
    --subtitle-color: #475569;
    --body-text: #0f172a;
    --muted-text: #64748b;
    --input-background: #f8fafc;
    --input-border: rgba(15, 23, 42, 0.12);
    --input-focus-background: #ffffff;
    --input-shadow: rgba(37, 99, 235, 0.18);
    --input-placeholder: rgba(15, 23, 42, 0.45);
    --button-background: linear-gradient(135deg, #2563eb, #1d4ed8);
    --button-shadow: rgba(37, 99, 235, 0.35);
    --button-shadow-hover: rgba(37, 99, 235, 0.45);
    --alert-background: rgba(34, 197, 94, 0.12);
    --alert-text: #15803d;
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 48px 16px;
    background: var(--page-background);
}

.site-contact__card {
    width: 100%;
    max-width: 680px;
    border-radius: 24px;
    background: var(--card-background);
    border: 1px solid var(--card-border);
    box-shadow: 0 32px 70px -35px rgba(15, 23, 42, 0.35);
    overflow: hidden;
    color: var(--body-text);
}

.site-contact__header {
    padding: 40px 48px 28px;
    background: var(--header-background);
    color: var(--header-text);
    border-bottom: 1px solid var(--card-border);
}

.site-contact__logo {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 64px;
    height: 64px;
    margin-bottom: 18px;
    border-radius: 20px;
    background: var(--logo-background);
    box-shadow: inset 0 0 0 1px var(--logo-border);
    font-size: 26px;
    font-weight: 700;
    letter-spacing: 0.08em;
}

.site-contact__title {
    margin-bottom: 10px;
    font-size: 30px;
    font-weight: 600;
}

.site-contact__subtitle {
    margin: 0;
    font-size: 15px;
    color: var(--subtitle-color);
    line-height: 1.6;
}

.site-contact__body {
    padding: 40px 48px 48px;
    background: var(--card-background);
}

.site-contact__instructions {
    margin-bottom: 32px;
    font-size: 15px;
    color: var(--muted-text);
    line-height: 1.7;
}

.site-contact__form {
    display: grid;
    gap: 8px;
}

.site-contact__field {
    margin-bottom: 24px;
}

.site-contact__label {
    font-size: 13px;
    font-weight: 600;
    color: var(--muted-text);
    margin-bottom: 8px;
}

.site-contact__input {
    width: 100%;
    border-radius: 16px;
    border: 1px solid var(--input-border);
    background: var(--input-background);
    padding: 16px 18px;
    color: var(--body-text);
    transition: border-color 0.2s ease, box-shadow 0.2s ease, background 0.2s ease;
}

.site-contact__input:focus {
    border-color: #2563eb;
    background: var(--input-focus-background);
    box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.12);
}

.site-contact__input::placeholder {
    color: var(--input-placeholder);
}

.site-contact__input.is-invalid {
    border-color: #dc2626;
    box-shadow: 0 0 0 4px rgba(220, 38, 38, 0.1);
}

.site-contact__input.is-invalid:focus {
    border-color: #dc2626;
    box-shadow: 0 0 0 4px rgba(220, 38, 38, 0.15);
}

.site-contact__textarea {
    min-height: 140px;
    resize: vertical;
    padding-top: 18px;
}

.site-contact__captcha-field {
    margin-bottom: 32px;
}

.site-contact__captcha {
    display: grid;
    grid-template-columns: auto 1fr;
    gap: 16px;
    align-items: center;
}

.site-contact__captcha-visual {
    display: flex;
    align-items: center;
    justify-content: center;
}

.site-contact__captcha-input {
    width: 100%;
}

.site-contact__captcha-image {
    border-radius: 14px;
    overflow: hidden;
    box-shadow: inset 0 0 0 1px rgba(15, 23, 42, 0.08);
}

.site-contact__actions {
    margin-top: 12px;
}

.site-contact__submit {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 100%;
    padding: 14px 20px;
    border-radius: 14px;
    border: none;
    background: var(--button-background);
    color: #ffffff;
    font-weight: 600;
    letter-spacing: 0.02em;
    box-shadow: 0 20px 32px -20px var(--button-shadow);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.site-contact__submit:hover {
    transform: translateY(-1px);
    box-shadow: 0 24px 36px -20px var(--button-shadow-hover);
}

.site-contact__submit:focus-visible {
    outline: 2px solid rgba(37, 99, 235, 0.4);
    outline-offset: 4px;
}

.site-contact__error {
    margin-top: 8px;
    font-size: 13px;
    font-weight: 500;
    color: #dc2626;
}

.site-contact__alert {
    margin-bottom: 24px;
    border: none;
    border-radius: 20px;
    padding: 20px 24px;
    background: var(--alert-background);
    color: var(--alert-text);
    font-weight: 500;
}

.site-contact__mailer-note {
    font-size: 14px;
    color: var(--muted-text);
    line-height: 1.7;
    margin: 0;
}

.site-contact__mailer-note + .site-contact__mailer-note {
    margin-top: 16px;
}

.site-contact__code {
    display: inline-flex;
    align-items: center;
    padding: 0.15em 0.45em;
    border-radius: 6px;
    background: rgba(15, 23, 42, 0.06);
    font-size: 0.92em;
    font-family: 'JetBrains Mono', 'Fira Code', 'SFMono-Regular', Consolas, 'Liberation Mono', monospace;
}

@media (max-width: 720px) {
    .site-contact__card {
        border-radius: 20px;
    }

    .site-contact__header,
    .site-contact__body {
        padding: 32px 28px;
    }

    .site-contact__logo {
        margin-bottom: 16px;
    }

    .site-contact__title {
        font-size: 26px;
    }

    .site-contact__subtitle {
        font-size: 14px;
    }

    .site-contact__captcha {
        grid-template-columns: 1fr;
    }

    .site-contact__captcha-visual {
        justify-content: flex-start;
    }
}

@media (max-width: 480px) {
    .site-contact {
        padding: 32px 12px;
    }

    .site-contact__header,
    .site-contact__body {
        padding: 28px 20px;
    }

    .site-contact__title {
        font-size: 24px;
    }

    .site-contact__instructions {
        font-size: 14px;
    }
}
CSS);
?>

<div class="site-contact">
    <div class="site-contact__card">
        <div class="site-contact__header">
            <div class="site-contact__logo">IT</div>
            <h1 class="site-contact__title"><?= Html::encode($this->title) ?></h1>
            <p class="site-contact__subtitle">We'd love to hear from you. Send us a message and our team will be in touch shortly.</p>
        </div>
        <div class="site-contact__body">
            <?php if (Yii::$app->session->hasFlash('contactFormSubmitted')): ?>
                <div class="site-contact__alert">
                    Thank you for contacting us. We will respond to you as soon as possible.
                </div>

                <p class="site-contact__mailer-note">
                    Note that if you turn on the Yii debugger, you should be able
                    to view the mail message on the mail panel of the debugger.
                </p>
                <?php if (Yii::$app->mailer->useFileTransport): ?>
                    <p class="site-contact__mailer-note">
                        Because the application is in development mode, the email is not sent but saved as
                        a file under <code class="site-contact__code"><?= Yii::getAlias(Yii::$app->mailer->fileTransportPath) ?></code>.
                        Please configure the <code class="site-contact__code">useFileTransport</code> property of the <code class="site-contact__code">mail</code>
                        application component to be false to enable email sending.
                    </p>
                <?php endif; ?>
            <?php else: ?>
                <p class="site-contact__instructions">
                    If you have business inquiries or other questions, please fill out the following form to contact us. Thank you.
                </p>

                <?php $form = ActiveForm::begin([
                    'id' => 'contact-form',
                    'options' => ['class' => 'site-contact__form'],
                    'fieldConfig' => [
                        'options' => ['class' => 'site-contact__field'],
                        'labelOptions' => ['class' => 'form-label site-contact__label'],
                        'inputOptions' => ['class' => 'form-control site-contact__input'],
                        'errorOptions' => ['class' => 'site-contact__error'],
                    ],
                ]); ?>

                    <?= $form->field($model, 'name')->textInput([
                        'autofocus' => true,
                        'placeholder' => 'Full name',
                    ]) ?>

                    <?= $form->field($model, 'email')->input('email', [
                        'placeholder' => 'Email address',
                    ]) ?>

                    <?= $form->field($model, 'subject')->textInput([
                        'placeholder' => 'Subject',
                    ]) ?>

                    <?= $form->field($model, 'body')->textarea([
                        'rows' => 6,
                        'class' => 'form-control site-contact__input site-contact__textarea',
                        'placeholder' => 'How can we help?',
                    ]) ?>

                    <?= $form->field($model, 'verifyCode', [
                        'options' => ['class' => 'site-contact__field site-contact__captcha-field'],
                    ])->widget(Captcha::class, [
                        'template' => '<div class="site-contact__captcha"><div class="site-contact__captcha-visual">{image}</div><div class="site-contact__captcha-input">{input}</div></div>',
                        'imageOptions' => ['class' => 'site-contact__captcha-image', 'alt' => 'Verification code'],
                        'options' => ['class' => 'form-control site-contact__input', 'placeholder' => 'Enter the code'],
                    ]) ?>

                    <div class="site-contact__actions">
                        <?= Html::submitButton('Send message', ['class' => 'site-contact__submit', 'name' => 'contact-button']) ?>
                    </div>

                <?php ActiveForm::end(); ?>

            <?php endif; ?>
        </div>
    </div>
</div>
