<?php

/** @var yii\web\View $this */
/** @var string $name */
/** @var string $message */
/** @var \Throwable $exception */

use yii\helpers\Html;

$this->title = $name;
?>
<div class="site-error">
    <v-row justify="center">
        <v-col cols="12" md="10" lg="8">
            <v-card elevation="1" class="pa-6 pa-sm-8">
                <v-card-title class="text-h5 font-weight-medium mb-4">
                    <?= Html::encode($this->title) ?>
                </v-card-title>
                <v-card-text class="text-body-1">
                    <v-alert type="error" variant="tonal" class="mb-4">
                        <?= nl2br(Html::encode($message)) ?>
                    </v-alert>
                    <p>
                        The above error occurred while the web server was processing your request. Please contact us if you
                        believe this is a server error.
                    </p>
                </v-card-text>
            </v-card>
        </v-col>
    </v-row>
</div>
