<?php

/** @var yii\web\View $this */

use yii\helpers\Html;

$this->title = 'My Yii Application';

$features = [
    [
        'title' => 'Documentation',
        'description' => 'Learn how to extend and customise your Yii application with the comprehensive documentation.',
        'url' => 'https://www.yiiframework.com/doc/',
        'cta' => 'Yii Documentation',
        'icon' => 'mdi-book-open-page-variant',
    ],
    [
        'title' => 'Community',
        'description' => 'Engage with the Yii community, ask questions, and share your knowledge with fellow developers.',
        'url' => 'https://www.yiiframework.com/forum/',
        'cta' => 'Yii Forum',
        'icon' => 'mdi-account-group',
    ],
    [
        'title' => 'Extensions',
        'description' => 'Discover high quality extensions to accelerate your development and add polished features.',
        'url' => 'https://www.yiiframework.com/extensions/',
        'cta' => 'Yii Extensions',
        'icon' => 'mdi-puzzle',
    ],
];
?>
<div class="site-index">
    <v-row justify="center" class="mb-10">
        <v-col cols="12" md="10" lg="8">
            <v-card class="hero-card pa-10 text-center" color="primary" variant="tonal" elevation="0">
                <div class="text-h3 text-sm-h2 font-weight-medium mb-4">Congratulations!</div>
                <div class="text-body-1 mb-6">
                    You have successfully created your Yii-powered application.
                </div>
                <v-btn
                    color="primary"
                    size="large"
                    prepend-icon="mdi-rocket-launch"
                    class="text-none"
                    href="https://www.yiiframework.com"
                    target="_blank"
                    rel="noopener"
                >
                    Get started with Yii
                </v-btn>
            </v-card>
        </v-col>
    </v-row>

    <v-row class="ga-6 features-row">
        <?php foreach ($features as $feature): ?>
            <v-col cols="12" md="4" class="feature-column">
                <v-card class="feature-card pa-6" elevation="2">
                    <v-avatar color="primary" variant="tonal" size="54" class="mb-4">
                        <v-icon size="30"><?= Html::encode($feature['icon']) ?></v-icon>
                    </v-avatar>
                    <div class="text-h5 font-weight-medium mb-3">
                        <?= Html::encode($feature['title']) ?>
                    </div>
                    <div class="text-body-2 text-medium-emphasis mb-6">
                        <?= Html::encode($feature['description']) ?>
                    </div>
                    <v-btn
                        color="primary"
                        variant="text"
                        class="px-0 text-none"
                        append-icon="mdi-arrow-top-right"
                        href="<?= Html::encode($feature['url']) ?>"
                        target="_blank"
                        rel="noopener"
                    >
                        <?= Html::encode($feature['cta']) ?>
                    </v-btn>
                </v-card>
            </v-col>
        <?php endforeach; ?>
    </v-row>
</div>
