<?php
/** @var yii\\web\\View $this */
/** @var app\\models\\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Login';

$this->registerCss(<<<'CSS'
.site-login {
    --page-background: #f8fafc;
    --card-background: #ffffff;
    --card-border: rgba(15, 23, 42, 0.08);
    --header-background: #ffffff;
    --header-text: #0f172a;
    --logo-background: rgba(15, 23, 42, 0.05);
    --logo-border: rgba(15, 23, 42, 0.1);
    --subtitle-color: #475569;
    --body-text: #0f172a;
    --muted-text: #64748b;
    --input-background: transparent;
    --input-border: rgba(15, 23, 42, 0.1);
    --input-focus-background: transparent;
    --input-shadow: rgba(59, 130, 246, 0.18);
    --input-icon: #2563eb;
    --placeholder-color: rgba(15, 23, 42, 0.45);
    --link-color: #2563eb;
    --link-hover: #1d4ed8;
    --button-background: linear-gradient(135deg, #2563eb, #1d4ed8);
    --button-shadow: rgba(37, 99, 235, 0.35);
    --button-shadow-hover: rgba(37, 99, 235, 0.45);
    --toggle-background: #e2e8f0;
    --toggle-icon: #0f172a;
    --alert-background: rgba(239, 68, 68, 0.12);
    --alert-text: #b91c1c;
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 48px 16px;
    background: var(--page-background);
    transition: background 0.3s ease;
}

.site-login.is-dark {
    --page-background: #0f172a;
    --card-background: rgba(15, 23, 42, 0.92);
    --card-border: rgba(148, 163, 184, 0.16);
    --header-background: rgba(15, 23, 42, 0.92);
    --header-text: #f8fafc;
    --logo-background: rgba(148, 163, 184, 0.1);
    --logo-border: rgba(148, 163, 184, 0.2);
    --subtitle-color: rgba(226, 232, 240, 0.7);
    --body-text: #e2e8f0;
    --muted-text: #94a3b8;
    --input-background: transparent;
    --input-border: rgba(148, 163, 184, 0.24);
    --input-focus-background: transparent;
    --input-shadow: rgba(37, 99, 235, 0.35);
    --input-icon: #60a5fa;
    --placeholder-color: rgba(226, 232, 240, 0.55);
    --link-color: #60a5fa;
    --link-hover: #3b82f6;
    --button-background: linear-gradient(135deg, #2563eb, #1d4ed8);
    --button-shadow: rgba(37, 99, 235, 0.45);
    --button-shadow-hover: rgba(37, 99, 235, 0.55);
    --toggle-background: rgba(148, 163, 184, 0.15);
    --toggle-icon: #f8fafc;
    --alert-background: rgba(239, 68, 68, 0.18);
    --alert-text: #fca5a5;
}

.site-login__card {
    width: 100%;
    max-width: 520px;
    border-radius: 20px;
    background: var(--card-background);
    box-shadow: 0 32px 70px -35px rgba(15, 23, 42, 0.4);
    overflow: hidden;
    border: 1px solid var(--card-border);
    color: var(--body-text);
    transition: background 0.3s ease, color 0.3s ease, border-color 0.3s ease;
}

.site-login__header {
    position: relative;
    padding: 32px 36px 24px;
    text-align: center;
    background: var(--header-background);
    color: var(--header-text);
    border-bottom: 1px solid var(--card-border);
}

.site-login__theme-toggle {
    position: absolute;
    top: 24px;
    right: 24px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 44px;
    height: 44px;
    border-radius: 14px;
    border: none;
    background: var(--toggle-background);
    color: var(--toggle-icon);
    cursor: pointer;
    transition: transform 0.2s ease, background 0.3s ease, color 0.3s ease;
}

.site-login__theme-toggle:hover {
    transform: translateY(-1px);
}

.site-login__theme-toggle:focus-visible {
    outline: 2px solid var(--input-icon);
    outline-offset: 2px;
}

.site-login__theme-toggle svg {
    width: 20px;
    height: 20px;
}

.site-login__theme-toggle-icon {
    display: none;
}

.site-login__theme-toggle-icon--sun {
    display: inline-flex;
}

.site-login.is-dark .site-login__theme-toggle-icon--sun {
    display: none;
}

.site-login.is-dark .site-login__theme-toggle-icon--moon {
    display: inline-flex;
}

.site-login__logo {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 64px;
    height: 64px;
    margin-bottom: 16px;
    border-radius: 20px;
    background: var(--logo-background);
    box-shadow: inset 0 0 0 1px var(--logo-border);
    font-size: 26px;
    font-weight: 700;
    letter-spacing: 0.04em;
}

.site-login__title {
    margin-bottom: 8px;
    font-size: 28px;
    font-weight: 600;
}

.site-login__subtitle {
    margin: 0;
    font-size: 15px;
    color: var(--subtitle-color);
}

.site-login__body {
    padding: 32px 36px 40px;
    background: var(--card-background);
    color: var(--body-text);
    transition: background 0.3s ease, color 0.3s ease;
}

.site-login__body .form-label {
    font-weight: 600;
    font-size: 14px;
    color: var(--muted-text);
}

.site-login__field {
    margin-bottom: 24px;
}

.site-login__input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
    width: 100%;
    background: var(--input-background);
    border: 1px solid var(--input-border);
    border-radius: 14px;
    padding: 0 16px;
    transition: box-shadow 0.2s ease, background 0.2s ease, border-color 0.2s ease;
}

.site-login__input-wrapper:focus-within {
    background: var(--input-focus-background);
    border-color: var(--input-icon);
    box-shadow: 0 0 0 4px var(--input-shadow);
}

.site-login__icon {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    color: var(--input-icon);
    margin-right: 12px;
}

.site-login__icon svg {
    width: 20px;
    height: 20px;
}

.site-login__body .form-control {
    border: none;
    background: transparent;
    padding: 14px 0;
    font-size: 15px;
    color: var(--body-text);
    width: 100%;
}

.site-login__body .form-control:focus {
    box-shadow: none;
}

.site-login__body .form-control::placeholder {
    color: var(--placeholder-color);
    opacity: 1;
}


.site-login__toggle {
    border: none;
    background: none;
    color: var(--muted-text);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    padding: 0;
}

.site-login__toggle svg {
    width: 20px;
    height: 20px;
}

.site-login__toggle.is-active {
    color: var(--input-icon);
}

.site-login__remember {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 12px;
    color: var(--muted-text);
    font-size: 14px;
}

.site-login__remember .form-check-input {
    width: 18px;
    height: 18px;
    border-radius: 6px;
    border: 2px solid rgba(148, 163, 184, 0.6);
    cursor: pointer;
    background: transparent;
    transition: background 0.2s ease, border-color 0.2s ease, box-shadow 0.2s ease;
}

.site-login__remember .form-check-input:checked {
    background-color: var(--input-icon);
    border-color: var(--input-icon);
}

.site-login__remember .form-check-input:focus {
    box-shadow: 0 0 0 4px var(--input-shadow);
    border-color: var(--input-icon);
}

.site-login.is-dark .site-login__remember .form-check-input {
    border-color: rgba(148, 163, 184, 0.4);
}

.site-login__remember .form-check {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    margin: 0;
}

.site-login__remember .form-check-label {
    padding: 0;
    cursor: pointer;
    color: inherit;
}

.site-login__remember .site-login__link {
    margin-left: auto;
}

.site-login__alert {
    border-radius: 16px;
    background: var(--alert-background);
    color: var(--alert-text);
    padding: 16px 20px;
    margin-bottom: 20px;
    display: flex;
    align-items: flex-start;
    gap: 12px;
    transition: background 0.3s ease, color 0.3s ease;
}

.site-login__alert-icon {
    margin-top: 2px;
}

.site-login__alert-icon svg {
    width: 20px;
    height: 20px;
}

.site-login__alert-content {
    font-size: 14px;
    line-height: 1.5;
}

.site-login__actions {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 16px;
    margin-bottom: 18px;
}


.site-login__link {
    color: var(--link-color);
    font-weight: 500;
    font-size: 14px;
    text-decoration: none;
    transition: color 0.2s ease;
}

.site-login__link:hover {
    color: var(--link-hover);
}

.site-login__submit {
    position: relative;
    width: 100%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    border: none;
    border-radius: 16px;
    padding: 16px 20px;
    font-size: 16px;
    font-weight: 600;
    color: #ffffff;
    background: var(--button-background);
    box-shadow: 0 18px 30px -20px var(--button-shadow);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    cursor: pointer;
}

.site-login__submit:hover {
    transform: translateY(-1px);
    box-shadow: 0 22px 38px -24px var(--button-shadow-hover);
}

.site-login__submit:disabled {
    opacity: 0.8;
    cursor: not-allowed;
}

.site-login__spinner {
    width: 18px;
    height: 18px;
    border: 2px solid rgba(255, 255, 255, 0.35);
    border-top-color: #ffffff;
    border-radius: 50%;
    animation: site-login-spin 0.8s linear infinite;
    opacity: 0;
}

.site-login__submit.is-loading .site-login__spinner {
    opacity: 1;
}

.site-login__submit.is-loading .site-login__label {
    opacity: 0.85;
}

.site-login__footer {
    margin-top: 24px;
    text-align: center;
    font-size: 14px;
    color: var(--muted-text);
}

.site-login__footer a {
    color: var(--link-color);
    font-weight: 600;
    text-decoration: none;
}

.site-login__footer a:hover {
    color: var(--link-hover);
}

@keyframes site-login-spin {
    to {
        transform: rotate(360deg);
    }
}

@media (max-width: 640px) {
    .site-login__card {
        border-radius: 18px;
    }

    .site-login__header {
        padding: 32px 24px 20px;
    }

    .site-login__body {
        padding: 28px 24px 32px;
    }
}
CSS);

$this->registerJs(<<<'JS'
(function () {
    const container = document.querySelector('.site-login');
    const themeToggle = document.querySelector('.js-theme-toggle');
    const storageKey = 'site-login-theme';

    const applyTheme = function (theme) {
        if (!container) {
            return;
        }

        const isDark = theme === 'dark';
        container.classList.toggle('is-dark', isDark);

        if (themeToggle) {
            themeToggle.setAttribute('aria-label', isDark ? 'Switch to light theme' : 'Switch to dark theme');
        }
    };

    let storedTheme = null;
    try {
        storedTheme = window.localStorage.getItem(storageKey);
    } catch (error) {
        storedTheme = null;
    }

    const prefersDarkQuery = window.matchMedia ? window.matchMedia('(prefers-color-scheme: dark)') : null;
    const prefersDark = prefersDarkQuery ? prefersDarkQuery.matches : false;
    applyTheme(storedTheme || (prefersDark ? 'dark' : 'light'));

    if (!storedTheme && prefersDarkQuery) {
        const themeListener = function (event) {
            applyTheme(event.matches ? 'dark' : 'light');
        };

        if (typeof prefersDarkQuery.addEventListener === 'function') {
            prefersDarkQuery.addEventListener('change', themeListener);
        } else if (typeof prefersDarkQuery.addListener === 'function') {
            prefersDarkQuery.addListener(themeListener);
        }
    }

    if (themeToggle && container) {
        themeToggle.addEventListener('click', function () {
            const nextTheme = container.classList.contains('is-dark') ? 'light' : 'dark';
            applyTheme(nextTheme);

            try {
                window.localStorage.setItem(storageKey, nextTheme);
            } catch (error) {
                // Ignore storage errors (private browsing, etc.)
            }
        });
    }

    const form = document.querySelector('#login-form');
    if (!form) {
        return;
    }

    const passwordField = form.querySelector('.js-password-field input');
    const toggle = form.querySelector('.js-password-toggle');
    if (toggle && passwordField) {
        toggle.addEventListener('click', function () {
            const isPassword = passwordField.getAttribute('type') === 'password';
            passwordField.setAttribute('type', isPassword ? 'text' : 'password');
            this.classList.toggle('is-active', isPassword);
            this.setAttribute('aria-label', isPassword ? 'Hide password' : 'Show password');
        });
    }

    form.addEventListener('submit', function () {
        const submitButton = form.querySelector('.js-submit-button');
        if (submitButton) {
            submitButton.classList.add('is-loading');
            submitButton.setAttribute('disabled', 'disabled');
        }
    });
})();
JS);
?>
<div class="site-login">
    <div class="site-login__card">
        <div class="site-login__header">
            <button class="site-login__theme-toggle js-theme-toggle" type="button" aria-label="Switch to dark theme">
                <span class="site-login__theme-toggle-icon site-login__theme-toggle-icon--sun" aria-hidden="true">
                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="4" stroke="currentColor" stroke-width="1.6" />
                        <path d="M12 2V4" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M12 20V22" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M4 12H2" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M22 12H20" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M5.64 5.64L4.22 4.22" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M19.78 19.78L18.36 18.36" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M5.64 18.36L4.22 19.78" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                        <path d="M19.78 4.22L18.36 5.64" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" />
                    </svg>
                </span>
                <span class="site-login__theme-toggle-icon site-login__theme-toggle-icon--moon" aria-hidden="true">
                    <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M21 14.5C20.5373 14.6616 20.0482 14.75 19.54 14.75C15.7738 14.75 12.72 11.6962 12.72 7.93C12.72 6.94149 12.9364 6.00373 13.3241 5.16116C10.8617 5.99005 9 8.30046 9 11.01C9 14.7762 12.0538 17.83 15.82 17.83C17.9829 17.83 19.9117 16.7356 21 14.5Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </span>
            </button>
            <div class="site-login__logo" aria-hidden="true">CRM</div>
            <div class="site-login__title">Welcome back</div>
            <p class="site-login__subtitle">Sign in to your account to continue</p>
        </div>
        <div class="site-login__body">
            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'enableClientValidation' => true,
            ]); ?>

            <?php if ($model->hasErrors()): ?>
                <?php $firstError = Html::encode(reset($model->firstErrors)); ?>
                <div class="site-login__alert" role="alert">
                    <span class="site-login__alert-icon" aria-hidden="true">
                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 9V13" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M12 17H12.01" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M10.29 3.86L2.82 17.01C2.64 17.33 2.54 17.69 2.54 18.05C2.54 19.14 3.43 20.03 4.52 20.03H19.48C19.84 20.03 20.2 19.93 20.52 19.75C21.49 19.21 21.82 17.99 21.28 17.02L13.81 3.86C13.23 2.86 11.87 2.86 11.29 3.86H10.29Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </span>
                    <div class="site-login__alert-content">
                        <strong>We couldn’t sign you in.</strong><br />
                        <span><?= $firstError ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <div class="site-login__field">
                <?= $form->field($model, 'username', [
                    'template' => '{label}<div class="site-login__input-wrapper">'
                        . '<span class="site-login__icon" aria-hidden="true">
                                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M21 12V7C21 5.89543 20.1046 5 19 5H5C3.89543 5 3 5.89543 3 7V17C3 18.1046 3.89543 19 5 19H12" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M3 7L12 12L21 7" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                    <circle cx="17" cy="17" r="3" stroke="currentColor" stroke-width="1.6" />
                                </svg>
                            </span>'
                        . '{input}</div>{error}',
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control', 'placeholder' => 'Email address'],
                    'errorOptions' => ['class' => 'invalid-feedback'],
                ])->textInput(['autofocus' => true, 'required' => true])->label('Email address'); ?>
            </div>

            <div class="site-login__field js-password-field">
                <?= $form->field($model, 'password', [
                    'template' => '{label}<div class="site-login__input-wrapper">'
                        . '<span class="site-login__icon" aria-hidden="true">
                                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect x="3" y="11" width="18" height="10" rx="2" stroke="currentColor" stroke-width="1.6" />
                                    <path d="M8 11V7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7V11" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </span>'
                        . '{input}'
                        . '<button class="site-login__toggle js-password-toggle" type="button" aria-label="Show password">
                                <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2 12C2 12 5.5 5 12 5C18.5 5 22 12 22 12C22 12 18.5 19 12 19C5.5 19 2 12 2 12Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M12 15C13.6569 15 15 13.6569 15 12C15 10.3431 13.6569 9 12 9C10.3431 9 9 10.3431 9 12C9 13.6569 10.3431 15 12 15Z" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>'
                        . '</div>{error}',
                    'labelOptions' => ['class' => 'form-label'],
                    'inputOptions' => ['class' => 'form-control', 'placeholder' => 'Password'],
                    'errorOptions' => ['class' => 'invalid-feedback'],
                ])->passwordInput(['required' => true])->label('Password'); ?>
            </div>

            <div class="site-login__remember">
                <?= $form->field($model, 'rememberMe')->checkbox([
                    'template' => '<div class="form-check">{input}{label}{error}</div>',
                    'labelOptions' => ['class' => 'form-check-label'],
                ]) ?>
                <?= Html::a('Forgot password?', ['site/contact'], ['class' => 'site-login__link']) ?>
            </div>

            <button class="site-login__submit js-submit-button" type="submit">
                <span class="site-login__spinner" aria-hidden="true"></span>
                <span class="site-login__label">Login</span>
            </button>

            <?php ActiveForm::end(); ?>

            <div class="site-login__footer">
                Need an account? <?= Html::a('Request access', ['site/contact']) ?>
            </div>
        </div>
    </div>
</div>
