<?php

namespace app\widgets;

use Yii;
use yii\helpers\Html;

/**
 * Alert widget renders a message from session flash. All flash messages are displayed
 * in the sequence they were assigned using setFlash. You can set message as following:
 *
 * ```php
 * Yii::$app->session->setFlash('error', 'This is the message');
 * Yii::$app->session->setFlash('success', 'This is the message');
 * Yii::$app->session->setFlash('info', 'This is the message');
 * ```
 *
 * Multiple messages could be set as follows:
 *
 * ```php
 * Yii::$app->session->setFlash('error', ['Error 1', 'Error 2']);
 * ```
 *
 * @author Kartik Visweswaran <kartikv2@gmail.com>
 * @author Alexander Makarov <sam@rmcreative.ru>
 */
class Alert extends \yii\bootstrap5\Widget
{
    /**
     * @var array the alert types configuration for the flash messages.
     * This array is setup as $key => $value, where:
     * - key: the name of the session flash variable
     * - value: the Vuetify alert configuration (type, color, etc.)
     */
    public $alertTypes = [
        'error' => ['type' => 'error'],
        'danger' => ['type' => 'error'],
        'success' => ['type' => 'success'],
        'info' => ['type' => 'info'],
        'warning' => ['type' => 'warning'],
    ];
    /**
     * @var array the options for rendering the close button tag.
     * Array will be passed to [[\yii\bootstrap\Alert::closeButton]].
     */
    public $closeButton = [];


    /**
     * {@inheritdoc}
     */
    public function run()
    {
        $session = Yii::$app->session;
        $baseClass = trim(($this->options['class'] ?? '') . ' mb-4');

        foreach (array_keys($this->alertTypes) as $type) {
            $flash = $session->getFlash($type);

            foreach ((array) $flash as $i => $message) {
                $config = $this->alertTypes[$type];
                $options = array_merge($this->options, [
                    'id' => $this->getId() . '-' . $type . '-' . $i,
                    'class' => $baseClass,
                    'type' => $config['type'] ?? 'info',
                    'variant' => $config['variant'] ?? 'tonal',
                ]);

                if (isset($config['color'])) {
                    $options['color'] = $config['color'];
                }

                echo Html::tag('v-alert', $message, $options);
            }

            $session->removeFlash($type);
        }
    }
}
